local assets=
{
	Asset("ANIM", "anim/kolobok.zip"),
	Asset("IMAGE", "images/inventoryimages/kolobok.tex"),
	Asset("ATLAS", "images/inventoryimages/kolobok.xml"),
}

local function healowner(inst, owner)
    if (owner.components.health and owner.components.health:IsHurt()) then
        owner.components.health:DoDelta(2,1)
end
end

local function hurtowner(inst, owner)
	if (owner.components.health) then
		owner.components.health:DoDelta(-2,-1)
end
end

local function onequip(inst, owner) 
    if owner:HasTag("antirad") then
	owner.AnimState:OverrideSymbol("swap_body", "kolobok", "swap_body")
	inst.task = inst:DoPeriodicTask(30, healowner, nil, owner)
	owner:AddTag("rad")
	else
	owner.AnimState:OverrideSymbol("swap_body", "kolobok", "swap_body")
	inst.task = inst:DoPeriodicTask(2, hurtowner, nil, owner)
	owner:AddTag("rad")
	end
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
	owner:RemoveTag("rad")
	if inst.task ~= nil then
        inst.task:Cancel()
        inst.task = nil
    end
end




local function fnab()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)   
	
    inst.AnimState:SetBank("kolobok")
    inst.AnimState:SetBuild("kolobok")
    inst.AnimState:PlayAnimation("idle", false)
    	
    inst:AddComponent("inspectable")
	
	inst:AddTag("backpack")
    	
	-- inst:AddComponent("stackable")
	-- inst.components.stackable.maxsize = 1
		
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/marblearmour"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/kolobok.xml"
        	
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BACK or EQUIPSLOTS.BODY
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
	inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = 15
	
	if IsDLCEnabled(0002) then
	MakeInventoryFloatable(inst, "anim", "anim")
	end
	
    return inst
end

return Prefab( "common/inventory/kolobok", fnab, assets) 